﻿Public Class SettingsForm
    Public Sub New(ByRef s As ProgramSettings)

        ' This call is required by the Windows Form Designer.
        InitializeComponent()

        ' Add any initialization after the InitializeComponent() call.
        mySettings = s
        Me.DialogResult = Windows.Forms.DialogResult.No

        ' Enumerate COM ports
        Dim COMports() As String = System.IO.Ports.SerialPort.GetPortNames
        Array.Sort(COMports)
        ComboCOM.Items.AddRange(COMports)

        If Not String.IsNullOrEmpty(mySettings.PortName) AndAlso ComboCOM.Items.Contains(mySettings.PortName) Then
            ComboCOM.SelectedItem = mySettings.PortName
        End If

    End Sub

    Public mySettings As ProgramSettings

    Private Sub ButtonSave_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSave.Click
        mySettings.PortName = ComboCOM.SelectedItem
        Me.DialogResult = Windows.Forms.DialogResult.Yes
        Me.Close()
    End Sub

    Private Sub ButtonCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonCancel.Click
        Me.Close()
    End Sub
End Class